/*==============================================================================
Labor Market Variables for Canada, 1976-2012 

I. Calculate Population, 1971-2012
Source: 
Statistics Canada. Table 051-0001 - Estimates of population, by age group and sex for July 1, Canada, provinces and territories, annual (persons unless otherwise noted)
(accessed: June 13, 2013)

II. Employment, Labor Force, Unemployed, Unemployment Rate, 1976-2012 
Source:
Table 282-0002 Labour force survey estimates (LFS), by sex and detailed age group, annual (persons x 1,000)(11,12)

III. Employment, 1970-1974
Source: Estimates of employees by province and industry, 1961-1974, Ottawa: Statistics Canada, Labour Division, Monthly Employment, Payrolls and Labour Income Section, Catalogue 72-514 Occasional. November 1975. 
==============================================================================*/

clear 
set more off

cd "$insheet_files/Canada"

*===============================================================================
* I. Calculate Population, 1971-2012
*===============================================================================
insheet using "CA_cansim_POP.csv", name comma

drop if geo=="Northwest Territories (4)" ///
	| geo=="Northwest Territories including Nunavut (3)" ///
	| geo=="Nunavut (4)" | geo=="Yukon"

forval x=4/45 {
	local year = 1967+`x'
	rename v`x' y`year'
}

keep if sex	 == "Both sexes"
keep if agegroup == "All ages"

reshape long y, i(geo) j(year)
rename y POP

replace POP = POP/1000 

keep geo year POP

tempfile CA_POP_1971_2012
save 	`CA_POP_1971_2012.dta'

*===============================================================================
* II. Employment, Labor Force, Unemployed, Unemployment Rate, 1976-2012
*===============================================================================
import excel "CA_cansim_labor.xls", first cellrange(A4:AO972) clear

keep if Age =="15 years and over"
drop Age

local year = 1976
foreach var of varlist E-AO {
	local year=`year'
	rename `var' y`year'
	local year = `year'+1
}

reshape long y, i(geo Sex Labour) j(year)
rename y number

replace Labour = "EMP" if Labour=="Employment (3)"
replace Labour = "UNEMP" if Labour=="Unemployment (6)"

reshape wide number, i(geo Sex year) j(Labour) string 
reshape wide number*, i(geo year) j(Sex) string

gen EMP_cansim 	 	= numberEMPMales + numberEMPFemales 
gen UNEMP_cansim 	= numberUNEMPMales + numberUNEMPFemales 
gen LF_cansim	 	= EMP_cansim + UNEMP_cansim

keep geography year EMP_cansim UNEMP_cansim LF_cansim

tempfile CA_labor_1976_2012
save 	`CA_labor_1976_2012.dta'

*===============================================================================
* III. Merge data
*===============================================================================

sort year geo
merge 1:1 year geo using `CA_POP_1971_2012.dta', nogen
merge 1:1 year geo using `CA_labor_1976_2012.dta', nogen update

*===============================================================================
* IV. Create Canada NUTS equivalent 
*===============================================================================

gen region =.
replace region= 1 if geo=="Canada"
replace region= 124001 if geo =="Prince Edward Island"
replace region= 124002 if geo =="Nova Scotia" 
replace region= 124003 if geo =="New Brunswick"
replace region= 124004 if geo =="Quebec" 
replace region= 124005 if geo =="Ontario" 
replace region= 124006 if geo =="Manitoba" 
replace region= 124007 if geo =="Saskatchewan" 
replace region= 124008 if geo =="Alberta"
replace region= 124009 if geo =="British Columbia"
replace region= 124010 if geo =="Newfoundland and Labrador"

#delim ;
label define region_wvs_labels  
1 "Canada"
124001 "Prince Edward Island"
124002 "Nova Scotia" 
124003 "New Brunswick"
124004 "Quebec" 
124005 "Ontario" 
124006 "Manitoba" 
124007 "Saskatchewan" 
124008 "Alberta"
124009 "British Columbia"
124010 "Newfoundland and Labrador" ;
#delim cr 

label val region region_wvs_labels

gen nuts = ""
replace nuts = "Canada" if region ==1
replace nuts = "CA: Prince Edward Island" if region == 124001
replace nuts =  "CA: Nova Scotia"  if region ==  124002
replace nuts =  "CA: New Brunswick"  if region == 124003
replace nuts =  "CA: Quebec"  if region == 124004
replace nuts =  "CA: Ontario"  if region ==  124005
replace nuts =  "CA: Manitoba"  if region ==  124006
replace nuts =  "CA: Saskatchewan"  if region ==  124007
replace nuts =  "CA: Alberta" if region ==  124008
replace nuts =  "CA: British Columbia"  if region == 124009
replace nuts =  "CA: Newfoundland and Labrador"  if region == 124010

drop geo

save "$dta_files/CA_labor", replace 
